package gov.va.med.mhv.sm.admin.converter;


import org.springframework.stereotype.Component;

import gov.va.med.mhv.sm.admin.dto.ClinicianDTO;
import gov.va.med.mhv.sm.admin.jpa.model.Clinician;
import gov.va.med.mhv.sm.admin.jpa.model.ClinicianTriageMap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@Component
public class SMUserConverter {
	
	  public static List<ClinicianDTO> convertClinicianTriageMapList(Collection<ClinicianTriageMap> clinicianTgList){
	    	List<ClinicianDTO> clinicianDtoList = new ArrayList<ClinicianDTO>();
	    	clinicianTgList.stream().forEach((ClinicianTriageMap)->{
	    		ClinicianDTO clinicianDto = new ClinicianDTO();
	    		clinicianDto.setClinicianId(ClinicianTriageMap.getClinician().getId());
	    		clinicianDto.setClinicianName(ClinicianTriageMap.getClinician().getName());
	    		clinicianDto.setDuz(ClinicianTriageMap.getClinician().getDuz());
	    		clinicianDtoList.add(clinicianDto);
	    	});
	    	return clinicianDtoList;
	    }
	  
	  
	  public static List<ClinicianDTO> convertClinicianObjectList(Collection<Object[]> clinicianObjList){
	    	List<ClinicianDTO> clinicianDtoList = new ArrayList<ClinicianDTO>();
	    	clinicianObjList.stream().forEach((Object)->{
	    		ClinicianDTO clinicianDto = new ClinicianDTO();
	    		clinicianDto.setClinicianId(new Long(Object[0].toString()));
	    		clinicianDto.setClinicianName(Object[1].toString()+" ,"+Object[2].toString());
	    		clinicianDto.setDuz(Object[3].toString());
	    		clinicianDtoList.add(clinicianDto);
	    	});
	    	return clinicianDtoList;
	    }
	
	
	public static List<ClinicianDTO> convertClinicianList(Collection<Clinician> clinicianList){
    	List<ClinicianDTO> clinicianDtoList = new ArrayList<ClinicianDTO>();
    	clinicianList.stream().forEach((Clinician)->{
    		ClinicianDTO clinicianDto = new ClinicianDTO();
    		clinicianDto.setClinicianId(Clinician.getId());
    		clinicianDto.setClinicianName(Clinician.getName());
    		clinicianDto.setDuz(Clinician.getDuz());
    		clinicianDtoList.add(clinicianDto);
    	});
    	return clinicianDtoList;
    }
	  
}
